<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function drinks()
    {
        return $this->belongsToMany('App\Models\Drink', 'item_drinks', 'item_id', 'drink_id');
    }

    public function store()
    {
        return $this->belongsTo('App\Models\StoreCategory');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\StoreCategory');
    }

    public function sides()
    {
        return $this->hasMany('App\Models\Side');
    }

}